/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.fragment;

import icyllis.modernui.fragment.Fragment;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FragmentTransaction {
    static final int OP_NULL = 0;
    static final int OP_ADD = 1;
    static final int OP_REPLACE = 2;
    static final int OP_REMOVE = 3;
    static final int OP_HIDE = 4;
    static final int OP_SHOW = 5;
    static final int OP_DETACH = 6;
    static final int OP_ATTACH = 7;
    static final int OP_SET_PRIMARY_NAV = 8;
    static final int OP_UNSET_PRIMARY_NAV = 9;
    static final int OP_SET_MAX_LIFECYCLE = 10;
    List<Op> mOps = new ArrayList<Op>();

    void addOp(Op op) {
        this.mOps.add(op);
    }

    @Nonnull
    public FragmentTransaction add(@Nonnull Fragment fragment, @Nullable String tag) {
        this.doAddOp(0, fragment, tag, 1);
        return this;
    }

    @Nonnull
    public FragmentTransaction add(int containerViewId, @Nonnull Fragment fragment) {
        this.doAddOp(containerViewId, fragment, null, 1);
        return this;
    }

    @Nonnull
    public FragmentTransaction add(int containerViewId, @Nonnull Fragment fragment, @Nullable String tag) {
        this.doAddOp(containerViewId, fragment, tag, 1);
        return this;
    }

    void doAddOp(int containerViewId, @Nonnull Fragment fragment, @Nullable String tag, int cmd) {
        Class<?> fragmentClass = fragment.getClass();
        int modifiers = fragmentClass.getModifiers();
        if (fragmentClass.isAnonymousClass() || !Modifier.isPublic(modifiers) || fragmentClass.isMemberClass() && !Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("Fragment " + fragmentClass.getCanonicalName() + " must be a public static class to be  properly recreated from instance state.");
        }
        if (tag != null) {
            if (fragment.mTag != null && !tag.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + tag);
            }
            fragment.mTag = tag;
        }
        if (containerViewId != 0) {
            if (containerViewId == -1) {
                throw new IllegalArgumentException("Can't add fragment " + fragment + " with tag " + tag + " to container view with no id");
            }
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != containerViewId) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + containerViewId);
            }
            fragment.mContainerId = fragment.mFragmentId = containerViewId;
        }
        this.addOp(new Op(cmd, fragment));
    }

    @Nonnull
    public FragmentTransaction replace(int containerViewId, @Nonnull Fragment fragment) {
        return this.replace(containerViewId, fragment, null);
    }

    @Nonnull
    public FragmentTransaction replace(int containerViewId, @Nonnull Fragment fragment, @Nullable String tag) {
        if (containerViewId == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(containerViewId, fragment, tag, 2);
        return this;
    }

    @Nonnull
    public FragmentTransaction remove(@Nonnull Fragment fragment) {
        this.addOp(new Op(3, fragment));
        return this;
    }

    @Nonnull
    public FragmentTransaction hide(@Nonnull Fragment fragment) {
        this.addOp(new Op(4, fragment));
        return this;
    }

    @Nonnull
    public FragmentTransaction show(@Nonnull Fragment fragment) {
        this.addOp(new Op(5, fragment));
        return this;
    }

    @Nonnull
    public FragmentTransaction detach(@Nonnull Fragment fragment) {
        this.addOp(new Op(6, fragment));
        return this;
    }

    @Nonnull
    public FragmentTransaction attach(@Nonnull Fragment fragment) {
        this.addOp(new Op(7, fragment));
        return this;
    }

    public boolean isEmpty() {
        return this.mOps.isEmpty();
    }

    static final class Op {
        int mCmd;
        Fragment mFragment;

        Op(int cmd, Fragment fragment) {
            this.mCmd = cmd;
            this.mFragment = fragment;
        }
    }
}

